﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace AplikacjaBazodanowa
{
    public partial class Form1 : Form
    {
        private bool daneZmienione = false;

        public Form1()
        {
            InitializeComponent();
        }        

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'adresyDataSet.Osoby' table. You can move, or remove it, as needed.
            this.osobyTableAdapter.Fill(this.adresyDataSet.Osoby);
            this.osobyBindingSource.Position = 2;
            daneZmienione = false;
        }

        private void osobyBindingSource_CurrentChanged(object sender, EventArgs e)
        {
            AdresyDataSet.OsobyRow rekord = (osobyBindingSource.Current as DataRowView).Row as AdresyDataSet.OsobyRow;
            Text = rekord.Imię + " " + rekord.Nazwisko;
            try { int numerDomu = rekord.NumerDomu; }
            catch { numericUpDown1.Value = 0; }
            try { int numerMieszkania = rekord.NumerMieszkania; }
            catch { numericUpDown2.Value = 0; }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            daneZmienione = true;
        }

        private void Form1_Closing(object sender, CancelEventArgs e)
        {
            if (!daneZmienione) return;
            switch (MessageBox.Show(
                        "Czy zapisać zmiany do bazy danych?", "Adresy", 
                        MessageBoxButtons.YesNoCancel, 
                        MessageBoxIcon.Question, 
                        MessageBoxDefaultButton.Button2))
            {
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
                case DialogResult.Yes:
                    try
                    {
                        this.osobyBindingSource.EndEdit();
                        this.osobyTableAdapter.Update(adresyDataSet.Osoby);
                        MessageBox.Show("Dane zapisane do bazy");
                    }
                    catch (Exception exc)
                    {
                        MessageBox.Show("Zapisanie danych nie powiodło się (" + exc.Message + ")");
                    }
                    break;
                case DialogResult.No:
                    break;
            }
        }
    }
}